/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.websm.diagnostics.IDebug;
import java.io.RandomAccessFile;

public class Trace {
    public static final int DEBUG = 3;
    public static final int FDEBUG = 2;
    public static final int TRACE = 1;
    public static int LEVEL = Trace.initTraceLevel();
    private static final String TRACE_FILE_NAME = "/opt/hsc/data/traceLevel.dat";

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 2) {
            if (stringArray[0].equalsIgnoreCase("set")) {
                n = Trace.levelString(stringArray[1]);
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: {
                        Trace.persistTLevel(n);
                        System.out.println("Trace level set to " + stringArray[1] + ".");
                        break;
                    }
                }
            } else if (stringArray[0].equalsIgnoreCase("query")) {
                System.out.println("Trace level is " + LEVEL + ".");
            }
        } else if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("query")) {
            System.out.println("Trace level is " + LEVEL + ".");
        }
    }

    public static void trace(String string, String string2, Object object, ObjectDumperAttributes objectDumperAttributes) {
        if (HSCLogUtils.disableLogger) {
            return;
        }
        if (Trace.activeTraceLevel(string)) {
            com.ibm.hwmca.fw.util.Trace.trace((String)string, (String)string2, (Object)object, (ObjectDumperAttributes)objectDumperAttributes);
        }
    }

    public static void trace(String string, String string2, Object object) {
        if (HSCLogUtils.disableLogger) {
            return;
        }
        if (Trace.activeTraceLevel(string)) {
            com.ibm.hwmca.fw.util.Trace.trace((String)string, (String)string2, (Object)object, (ObjectDumperAttributes)ObjectDumperAttributes.DEFAULT);
        }
    }

    public static void trace(String string, Object object, ObjectDumperAttributes objectDumperAttributes) {
        if (HSCLogUtils.disableLogger) {
            return;
        }
        if (Trace.activeTraceLevel(string)) {
            com.ibm.hwmca.fw.util.Trace.trace((String)string, (String)"", (Object)object, (ObjectDumperAttributes)objectDumperAttributes);
        }
    }

    public static void trace(String string, Object object) {
        if (HSCLogUtils.disableLogger) {
            return;
        }
        if (Trace.activeTraceLevel(string)) {
            com.ibm.hwmca.fw.util.Trace.trace((String)string, (String)"", (Object)object, (ObjectDumperAttributes)ObjectDumperAttributes.DEFAULT);
        }
    }

    private static boolean activeTraceLevel(String string) {
        boolean bl = false;
        try {
            switch (string.charAt(7)) {
                case 'T': {
                    if (LEVEL < 1) break;
                    bl = true;
                    break;
                }
                case 'F': {
                    if (LEVEL < 2) break;
                    bl = true;
                    break;
                }
                case 'D': {
                    if (LEVEL < 3) break;
                    bl = true;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public static int setLevel(int n) {
        int n2 = -1;
        if (Trace.validTraceLevel(n)) {
            LEVEL = n;
            n2 = 0;
        }
        return n2;
    }

    public static int setLevel(String string) {
        int n = Trace.levelString(string);
        if (n == -1) {
            return n;
        }
        return Trace.setLevel(n);
    }

    private static boolean validTraceLevel(int n) {
        boolean bl = false;
        switch (n) {
            case 3: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1: {
                bl = true;
            }
        }
        return bl;
    }

    private static int levelString(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if ("DEBUG".equals(string = string.toUpperCase())) {
            n = 3;
        } else if ("FDEBUG".equals(string)) {
            n = 2;
        } else if ("TRACE".equals(string)) {
            n = 1;
        }
        return n;
    }

    public static void persistTLevel(int n) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(TRACE_FILE_NAME, "rw");
            randomAccessFile.writeInt(n);
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
            System.out.println("Trace::persistTLevel cannot create trace file: /opt/hsc/data/traceLevel.dat");
            throwable.printStackTrace();
        }
    }

    public static void persistTLevel(String string) {
        Trace.persistTLevel(Trace.levelString(string));
    }

    public static int getLEVEL() {
        return LEVEL;
    }

    private static int initTraceLevel() {
        int n = 2;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(TRACE_FILE_NAME, "r");
            n = randomAccessFile.readInt();
            randomAccessFile.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    static {
        try {
            System.loadLibrary("jniTrace");
        }
        catch (Throwable throwable) {
            try {
                if (!IDebug.enabled) {
                    com.ibm.hwmca.fw.util.Trace.setDefaultOutput(null);
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

